<?php

use \UtillzCore\Inc\Src\User;
use \UtillzCore\Inc\Src\Admin\Panel;

defined('ABSPATH') || exit;

global $post;

class Panel {
    private $form;

    public function getForm() {
        return $this->form;
    }
}

// In your code
$panel = \UtillzCore\Inc\Src\Admin\Panel::instance();
$form = $panel->getForm();


$user = new User( $post->post_author );
$user_data = $user->get_userdata();

$product_id = get_post_meta( get_the_ID(), 'ulz_product_id', true );
$order_id = get_post_meta( get_the_ID(), 'ulz_order_id', true );

?>

<div class="ulz-panel ulz-outer">
    <div class="ulz-section">
        <table class="ulz-table">
            <thead>
                <tr>
                    <th><?php esc_html_e('General details', 'utillz-core'); ?></th>
                    <th>&nbsp;</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?php esc_html_e('User', 'utillz-core'); ?></td>
                    <td><a href="<?php echo esc_url( get_edit_user_link( $user->id ) ); ?>"><?php echo esc_html( $user_data->display_name ); ?></a></td>
                </tr>
                <?php if( $product_id ): ?>
                    <tr>
                        <td><?php esc_html_e('Promotion', 'utillz-core'); ?></td>
                        <td><a href="<?php echo esc_url( get_edit_post_link( $product_id ) ); ?>"><?php echo get_the_title( $product_id ); ?></a></td>
                    </tr>
                <?php endif; ?>
                <?php if( $order_id ): ?>
                    <tr>
                        <td><?php esc_html_e('Order', 'utillz-core'); ?></td>
                        <td><a href="<?php echo esc_url( get_edit_post_link( $order_id ) ); ?>"><?php echo get_the_title( $order_id ); ?></a></td>
                    </tr>
                <?php endif; ?>
                <?php $attached_ids = get_post_meta( get_the_ID(), 'ulz_attached', false ); ?>
                <?php if( is_array( $attached_ids ) ): ?>
                    <?php
                        $attached = new \WP_Query([
                            'post_type' => 'ulz_listing',
                            'post__in' => $attached_ids ? $attached_ids : [0],
                        ]);
                    ?>
                    <?php if( $attached->found_posts ): ?>
                        <?php foreach( $attached->posts as $attached ): ?>
                            <?php $listing = new \UtillzCore\Inc\Src\Listing\Listing( $attached->ID ); ?>
                            <tr>
                                <td><?php esc_html_e('Listing', 'utillz-core'); ?></td>
                                <td><a href="<?php echo esc_url( get_edit_post_link( $attached->ID ) ); ?>"><?php echo get_the_title( $attached->ID ); ?></a></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                <?php endif; ?>
            </tbody>
        </table>

        <p class="ulz-mt-5"><strong><?php esc_html_e('Parameters', 'utillz-core'); ?></strong></p>

        <div class="ulz-form ulz-grid">

            <?php

                $form->render([
                    'type' => 'text',
                    'id' => 'ulz_duration',
                    'name' => esc_html__( 'Duration', 'utillz-core' ),
                    'description' => esc_html__( 'The number of days of the listing to be promoted.', 'utillz-core' ),
                    'disabled' => true,
                ]);

                $form->render([
                    'type' => 'text',
                    'id' => 'ulz_priority',
                    'name' => esc_html__( 'Priority', 'utillz-core' ),
                    'value' => 0,
                    'description' => esc_html__( 'Higher value means higher priority in search results.', 'utillz-core' ),
                    'disabled' => true,
                ]);


            ?>

        </div>
    </div>
</div>
